package ru.yandex.travel.hotels.common.orders;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

import ru.yandex.travel.hotels.common.partners.travelline.model.VatTaxType;
import ru.yandex.travel.hotels.common.partners.travelline.model.dto.OfferDto;
import ru.yandex.travel.hotels.proto.EPartnerId;

@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@NoArgsConstructor
public class TravellineHotelItinerary extends HotelItinerary {
    private OfferDto offer;
    private Integer selectedPlacement;
    private String yandexNumber;
    private String travellineNumber;
    private String yandexNumberPrefix;

    private VatTaxType vatTaxOverride;

    public String getYandexNumberPrefix() {
        return yandexNumberPrefix != null ? yandexNumberPrefix : "";
    }

    @Override
    public EPartnerId getPartnerId() {
        return EPartnerId.PI_TRAVELLINE;
    }
}
