package ru.yandex.travel.hotels.common.orders.promo;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;
import lombok.extern.jackson.Jacksonized;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@Data
@Builder
@Jacksonized
@JsonIgnoreProperties(ignoreUnknown = true)
public class YandexPlusApplication {
    private Mode mode;
    private Integer points;

    @AllArgsConstructor
    @Getter
    public enum Mode implements ValueBasedEnum<String> {
        TOPUP("TOPUP"),
        WITHDRAW("WITHDRAW");

        private static final EnumIndex<String, Mode> index = EnumIndex.create(Mode.class);

        @JsonValue
        private final String value;

        @JsonCreator
        public Mode forValue(String value) {
            return index.getByValue(value);
        }
    }
}
