package ru.yandex.travel.hotels.common.partners;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

import com.google.common.collect.ImmutableMap;

import ru.yandex.travel.commons.proto.ECurrency;

public class Utils {
    public static final ImmutableMap<ECurrency, String> CURRENCY_NAMES = ImmutableMap.of(
            ECurrency.C_RUB, "RUB",
            ECurrency.C_USD, "USD"
    );

    public static String createBasicAuthHeader(String username, String password) {
        return "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
    }

    private Utils() {
    }
}
