package ru.yandex.travel.hotels.common.partners.base

import com.google.protobuf.Message
import lombok.AllArgsConstructor
import lombok.Data
import ru.yandex.travel.hotels.proto.THotelTestContext
import ru.yandex.travel.hotels.common.token.TravelToken
import ru.yandex.travel.hotels.common.orders.HotelItinerary
import ru.yandex.travel.hotels.proto.TSearchOffersReq
import ru.yandex.travel.hotels.proto.TSearchOffersRpcReq
import ru.yandex.travel.hotels.common.partners.base.CallContext.CallPhase.OFFER_SEARCH

@Data
@AllArgsConstructor
class CallContext (
    val phase: CallPhase,
    val testContext: THotelTestContext? = null,
    val offerData: Message? = null,
    val travelToken: TravelToken? = null,
    val itinerary: HotelItinerary? = null,
    val searchOffersReq: TSearchOffersReq? = null
) {
    enum class CallPhase {
        OFFER_SEARCH,
        OFFER_VALIDATION,
        ORDER_CREATION,
        ORDER_RESERVATION,
        ORDER_CONFIRMATION,
        ORDER_CANCELLATION,
        ORDER_REFUND
    }

    companion object {
        @JvmStatic
        fun forSearcher(rpcRequest: TSearchOffersRpcReq?, searchOffersReq: TSearchOffersReq?): CallContext {
            return CallContext(
                phase = OFFER_SEARCH,
                testContext = if (rpcRequest != null && rpcRequest.hasTestContext()) rpcRequest.testContext else null,
                searchOffersReq = searchOffersReq
            )
        }
    }
}
