package ru.yandex.travel.hotels.common.partners.base;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;

import com.google.common.base.Supplier;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.hotels.proto.THotelTestContext;

@Slf4j
public class CallContextBaseClient {
    protected final CallContext callContext;

    public CallContextBaseClient(CallContext callContext) {
        this.callContext = callContext;
    }

    protected THotelTestContext getTestContext() {
        if (callContext == null) {
            return null;
        } else {
            return callContext.getTestContext();
        }
    }

    protected  <R> CompletableFuture<R> wrap(Supplier<CompletableFuture<R>> baseSupplier,
                                          Supplier<CompletableFuture<R>> mockSupplier) {
        if (getTestContext() == null) {
            return baseSupplier.get();
        } else {
            try {
                return Objects.requireNonNull(mockSupplier.get()).whenComplete((r, t) -> {
                    if (t == null) {
                        log.info("Mocked result: {}", r);
                    } else {
                        log.warn("Mock threw an exception", t);
                    }
                });
            } catch (Exception e) {
                return CompletableFuture.failedFuture(e);
            }
        }
    }

    protected <R> CompletableFuture<R> wrapIf(Supplier<CompletableFuture<R>> baseSupplier,
                                              Supplier<CompletableFuture<R>> mockSupplier,
                                              Predicate<THotelTestContext> condition
    ) {
        return wrap(baseSupplier, () -> {
            if (condition.test(getTestContext())) {
                return mockSupplier.get();
            } else {
                return baseSupplier.get();
            }
        });
    }

    protected <R> CompletableFuture<R> wrapForce(Supplier<CompletableFuture<R>> baseSupplier,
                                                 Supplier<CompletableFuture<R>> mockSupplier) {
        return wrapIf(baseSupplier, mockSupplier, THotelTestContext::getForceAvailability);
    }
}
