package ru.yandex.travel.hotels.common.partners.base;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import com.google.common.base.Preconditions;

import ru.yandex.bolts.collection.Tuple4;

public class ClientMethods {
    private final Map<String, Tuple4<String, BaseClient.HttpMethod, Class, Set<Integer>>> methods = new HashMap<>();

    public ClientMethods register(String destinationMethod, String endpoint, BaseClient.HttpMethod httpMethod,
                                     Class<?> responseClass) {

        return register(destinationMethod, endpoint, httpMethod, responseClass, Set.of(200));
    }

    public ClientMethods register(String destinationMethod, String endpoint, BaseClient.HttpMethod httpMethod,
                                     Class<?> responseClass, Set<Integer> responseCodes) {
        Preconditions.checkArgument(!methods.containsKey(destinationMethod), "Duplicate method " + destinationMethod);
        methods.put(destinationMethod, Tuple4.tuple(endpoint, httpMethod, responseClass, responseCodes));
        return this;
    }

    public Set<String> getNames() {
        return methods.keySet();
    }

    public Tuple4<String, BaseClient.HttpMethod, Class, Set<Integer>> get(String name) {
        return methods.get(name);
    }
}
