package ru.yandex.travel.hotels.common.partners.base;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ForcedTestScenario {
    SOLD_OUT_ON_HOLD("sold-out-on-hold"),
    PRICE_MISMATCH_ON_HOLD("price-mismatch-on-hold"),
    MINOR_PRICE_MISMATCH_ON_HOLD("minor-price-mismatch-on-hold"),
    NO_BOOKING_ON_CONFIRM("no-booking-on-confirm"),
    PRICE_MISMATCH_ON_CONFIRM("price-mismatch-on-confirm"),
    MINOR_PRICE_MISMATCH_ON_CONFIRM("minor-price-mismatch-on-confirm"),
    NO_TEST(null);

    private static String TEST_NAME = "test-scenario";
    private String value;

    ForcedTestScenario(String value) {
        this.value = value;
    }

    @JsonCreator
    protected static ForcedTestScenario fromString(String value) {
        for (ForcedTestScenario candidate : ForcedTestScenario.values()) {
            if (candidate.value != null && candidate.value.equalsIgnoreCase(value)) {
                return candidate;
            }
        }
        return NO_TEST;
    }

    public static ForcedTestScenario get(String firstName, String lastName) {
        if (firstName.equalsIgnoreCase(TEST_NAME)) {
            return fromString(lastName);
        }
        return NO_TEST;
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
