package ru.yandex.travel.hotels.common.partners.base;

import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;

import ru.yandex.travel.hotels.common.partners.base.exceptions.PartnerException;

public class Helpers {
    public static <T> T sync(CompletionStage<T> future) {
        try {
            return future.toCompletableFuture().join();
        } catch (CompletionException ex) {
            if (ex.getCause() instanceof PartnerException) {
                throw (PartnerException) ex.getCause();
            } else {
                throw new PartnerException(ex.getCause());
            }
        }
    }
}
