package ru.yandex.travel.hotels.common.partners.base;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

import com.google.common.base.Preconditions;

import ru.yandex.bolts.collection.Tuple2;

public class SOAPOperations {

    private final Map<String, Tuple2<String, BiFunction<?, ?, ?>>> methods = new HashMap<>();

    public SOAPOperations register(String operation, BiFunction<?, ?, ?> executor) {
        Preconditions.checkArgument(!methods.containsKey(operation), "Duplicate method " + operation);
        methods.put(operation, Tuple2.tuple(operation, executor));
        return this;
    }

    public Set<String> getNames() {
        return methods.keySet();
    }

    public Tuple2<String, BiFunction<?, ?, ?>> get(String name) {
        return methods.get(name);
    }

}
