package ru.yandex.travel.hotels.common.partners.base.exceptions;

import java.util.concurrent.TimeoutException;

import lombok.Getter;

import ru.yandex.travel.commons.http.apiclient.HttpApiRetryableException;

@Getter
public class RetryableHttpException extends HttpApiRetryableException {

    public RetryableHttpException(Integer statusCode, Object responseBody) {
        super(String.format("Unexpected HTTP status code '%s'", statusCode), null, statusCode, responseBody);
    }

    public RetryableHttpException(TimeoutException ex) {
        super("HTTP timeout exception", ex, null, null);
    }
}
