package ru.yandex.travel.hotels.common.partners.base.exceptions;

import lombok.Getter;

@Getter
public class UnexpectedHttpStatusCodeException extends PartnerException {
    public final int statusCode;
    private final String responseBody;


    public UnexpectedHttpStatusCodeException(int statusCode, String responseBody) {
        super(String.format("Unexpected HTTP status code '%s'", statusCode));
        this.responseBody = responseBody;
        this.statusCode = statusCode;
    }
}
