package ru.yandex.travel.hotels.common.partners.bnovo;

import java.util.Map;
import java.util.concurrent.CompletableFuture;

import ru.yandex.travel.hotels.common.partners.base.CallContext;
import ru.yandex.travel.hotels.common.partners.bnovo.model.Booking;
import ru.yandex.travel.hotels.common.partners.bnovo.model.BookingJson;
import ru.yandex.travel.hotels.common.partners.bnovo.model.BookingList;
import ru.yandex.travel.hotels.common.partners.bnovo.model.ConfirmationResponse;
import ru.yandex.travel.hotels.common.partners.bnovo.model.Hotel;
import ru.yandex.travel.hotels.common.partners.bnovo.model.HotelDetailsResponse;
import ru.yandex.travel.hotels.common.partners.bnovo.model.HotelStatusChangedResponse;
import ru.yandex.travel.hotels.common.partners.bnovo.model.HotelStayMap;
import ru.yandex.travel.hotels.common.partners.bnovo.model.LegalEntitiesResponse;
import ru.yandex.travel.hotels.common.partners.bnovo.model.LegalEntityResponse;
import ru.yandex.travel.hotels.common.partners.bnovo.model.PriceLosRequest;
import ru.yandex.travel.hotels.common.partners.bnovo.model.RatePlan;
import ru.yandex.travel.hotels.common.partners.bnovo.model.RoomType;
import ru.yandex.travel.hotels.common.partners.bnovo.model.Service;

import static ru.yandex.travel.hotels.common.partners.base.Helpers.sync;

public interface BNovoClient {

    CompletableFuture<Map<Long, RatePlan>> getRatePlans(long accountId, String httpRequestId);

    CompletableFuture<Map<Long, RoomType>> getRoomTypes(long accountId, String httpRequestId);

    CompletableFuture<HotelStayMap> getPrices(PriceLosRequest request);

    CompletableFuture<Map<Long, Hotel>> getAllHotels();

    CompletableFuture<Hotel> getHotelByAccountId(long accountId, String httpRequestId);

    CompletableFuture<Hotel> getHotelByUID(String uid);

    CompletableFuture<BookingList> createBooking(long accountId, BookingJson bookingJson);

    CompletableFuture<ConfirmationResponse> confirmBooking(String id);

    CompletableFuture<Booking> getBooking(long accountId, String number);

    CompletableFuture<Booking> cancelBooking(long accountId, String number, String email);

    CompletableFuture<HotelStatusChangedResponse> notifyHotelStatusChanged(String hotelCode);

    CompletableFuture<HotelDetailsResponse> getHotelDetails(String hotelCode);

    CompletableFuture<BookingList> getBookings(long accountId);

    CompletableFuture<Map<Long, Service>> getServices(long accountId, String httpRequestId);

    CompletableFuture<LegalEntitiesResponse> getLegalEntities(long accountId, String httpRequestId);

    CompletableFuture<LegalEntityResponse> getLegalEntity(long accountId, long entityId, String httpRequestId);


    default Map<Long, RatePlan> getRatePlansSync(long accountId, String httpRequestId) {
        return sync(getRatePlans(accountId, httpRequestId));
    }

    default Map<Long, RoomType> getRoomTypesSync(long accountId, String httpRequestId) {
        return sync(getRoomTypes(accountId, httpRequestId));
    }

    default HotelStayMap getPricesSync(PriceLosRequest request) {
        return sync(getPrices(request));
    }

    default Map<Long, Hotel> getAllHotelsSync() {
        return sync(getAllHotels());
    }

    default Hotel getHotelByAccountIdSync(long accountId, String requestId) {
        return sync(getHotelByAccountId(accountId, requestId));
    }

    default Hotel getHotelByUIDSync(String uid) {
        return sync(getHotelByUID(uid));
    }

    default BookingList createBookingSync(long accountId, BookingJson bookingJson) {
        return sync(createBooking(accountId, bookingJson));
    }

    default ConfirmationResponse confirmBookingSync(String id) {
        return sync(confirmBooking(id));
    }

    default Booking getBookingSync(long accountId, String number) {
        return sync(getBooking(accountId, number));
    }

    default Booking cancelBookingSync(long accountId, String number, String email) {
        return sync(cancelBooking(accountId, number, email));
    }

    default HotelStatusChangedResponse notifyHotelStatusChangedSync(String hotelCode) {
        return sync(notifyHotelStatusChanged(hotelCode));
    }

    default HotelDetailsResponse getHotelDetailsSync(String hotelCode) {
        return sync(getHotelDetails(hotelCode));
    }

    default BookingList getBookingsSync(long accountId) {
        return sync(getBookings(accountId));
    }

    default Map<Long, Service> getServicesSync(long accountId, String httpRequestId) {
        return sync(getServices(accountId, httpRequestId));
    }

    default LegalEntitiesResponse getLegalEntitiesSync(long accountId, String httpRequestId) {
        return sync(getLegalEntities(accountId, httpRequestId));
    }

    default LegalEntityResponse getLegalEntitySync(long accountId, long entityId, String httpRequestId) {
        return sync(getLegalEntity(accountId, entityId, httpRequestId));
    }


    default BNovoClient withCallContext(CallContext callContext) {
        return new CallContextBNovoClient(this, callContext);
    }
}
