package ru.yandex.travel.hotels.common.partners.bnovo;

import java.time.Duration;
import java.util.Map;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import lombok.Getter;
import lombok.Setter;

import ru.yandex.travel.hotels.common.partners.base.BaseClientProperties;

@Getter
@Setter
public class BNovoClientProperties extends BaseClientProperties {
    @NotBlank
    private String username;
    @NotBlank
    private String password;
    @NotNull
    private Duration tokenValidityDuration;
    @NotBlank
    private String privateApiBaseUrl;
    @NotBlank
    private String pricesLosApiBaseUrl;

    private int authenticationMaxRetryCount;
}
