package ru.yandex.travel.hotels.common.partners.bnovo;

import java.util.concurrent.CompletableFuture;

import com.google.common.base.Preconditions;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.commons.logging.AsyncHttpClientWrapper;
import ru.yandex.travel.commons.retry.Retry;
import ru.yandex.travel.hotels.common.partners.bnovo.model.Hotel;

@Slf4j
public class DefaultBNovoClientWithPublicRemapping extends DefaultBNovoClient {
    private final BNovoUidMap uidMap;

    public DefaultBNovoClientWithPublicRemapping(AsyncHttpClientWrapper clientWrapper, BNovoClientProperties properties,
                                                 BNovoUidMap uidMap, Retry retryHelper) {
        super(clientWrapper, properties, retryHelper);
        this.uidMap = uidMap;
    }

    @Override
    public CompletableFuture<Hotel> getHotelByAccountId(long accountId, String httpRequestId) {
        String uid = uidMap.getUidByOriginalId(String.valueOf(accountId));
        if (uid != null) {
            log.info("Will call public API instead of private: remapping original id {} to uid {}", accountId, uid);
            return getHotelByUID(uid).thenApply(h -> {
                Preconditions.checkState(h.getId() == accountId, "Unexpected account id");
                return h;
            });
        } else {
            return super.getHotelByAccountId(accountId, httpRequestId);
        }
    }
}
