package ru.yandex.travel.hotels.common.partners.bnovo.exceptions;

import lombok.Getter;

import ru.yandex.travel.hotels.common.partners.base.exceptions.PartnerException;
import ru.yandex.travel.hotels.common.partners.bnovo.model.ErrorResponse;

public class BNovoErrorException extends PartnerException {
    @Getter
    private final ErrorResponse errorResponse;

    public BNovoErrorException(ErrorResponse errorResponse) {
        super("Partner-side error has occurred");
        this.errorResponse = errorResponse;
    }

    public BNovoErrorException(ErrorResponse errorResponse, String message) {
        super(String.format("Partner-side error has occurred: %s", message));
        this.errorResponse = errorResponse;
    }
}
