package ru.yandex.travel.hotels.common.partners.bnovo.model;

import com.fasterxml.jackson.annotation.JsonCreator;

public enum AccommodationType {
    HOTEL_ROOM(0),
    APARTMENTS(1),
    BED(2),
    ROOM(3),
    SERVICE(4),
    OTHER(5);

    private int value;

    AccommodationType(int value) {
        this.value = value;
    }

    @JsonCreator
    public static AccommodationType fromInt(int value) {
        for (AccommodationType candidate : AccommodationType.values()) {
            if (candidate.value == value) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
            String.format("Unknown accommodation type %s", value)
        );
    }
}
