package ru.yandex.travel.hotels.common.partners.bnovo.model;

import com.fasterxml.jackson.annotation.JsonCreator;

public enum AdditionalServiceTaxSystem {
    COMMON(0),
    SIMPLE_INCOME(1),
    SIMPLE_INCOME_OUTLAY(2),
    UNIFIED_ON_TEMPORARY_INCOME(3),
    UNIFORM_AGRICULTURAL(4),
    PATENT(5);

    private final int value;

    AdditionalServiceTaxSystem(int value) {
        this.value = value;
    }

    @JsonCreator
    public static AdditionalServiceTaxSystem fromInt(int value) {
        for (AdditionalServiceTaxSystem candidate : AdditionalServiceTaxSystem.values()) {
            if (candidate.value == value) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown AdditionalServiceTaxSystem type %s", value)
        );
    }
}
