package ru.yandex.travel.hotels.common.partners.bnovo.model;

import com.fasterxml.jackson.annotation.JsonCreator;

public enum AdditionalServiceVat {
    VAT_NONE(0),
    VAT0(1),
    VAT10(2),
    VAT20(3);

    private final int value;

    AdditionalServiceVat(int value) {
        this.value = value;
    }

    @JsonCreator
    public static AdditionalServiceVat fromInt(int value) {
        for (AdditionalServiceVat candidate : AdditionalServiceVat.values()) {
            if (candidate.value == value) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown AdditionalServiceVat type %s", value)
        );
    }
}
