package ru.yandex.travel.hotels.common.partners.bnovo.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.hotels.common.partners.expedia.model.common.Deserializers;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = AdditionalServicesResponse.AdditionalServicesResponseBuilder.class)
public class AdditionalServicesResponse {
    private final List<Service> additionalServices;

    @JsonPOJOBuilder(withPrefix = "")
    public static class AdditionalServicesResponseBuilder {
        @JsonDeserialize(using = Deserializers.ListFromListOrMapDeserializer.class)
        private List<Service> additionalServices;
    }
}
