package ru.yandex.travel.hotels.common.partners.bnovo.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.commons.logging.masking.PersonalData;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = AuthRequest.AuthRequestBuilder.class)
public class AuthRequest {
    @PersonalData
    private String username;
    @PersonalData
    private String password;

    @JsonPOJOBuilder(withPrefix = "")
    public static class AuthRequestBuilder {
    }
}
