package ru.yandex.travel.hotels.common.partners.bnovo.model;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.travel.commons.logging.masking.PersonalData;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Booking.BookingBuilder.class)
public class Booking {
    private long accountId;
    private String otaId;
    private String otaBookingId;
    private BookingStatusId statusId;
    private long roomtypeId;
    private long planId;
    private long parentRoomTypeId;
    private String number;
    private LocalDateTime arrival;
    private LocalDateTime departure;
    @PersonalData
    private String name;
    @PersonalData
    private String surname;
    @PersonalData
    private String email;
    @PersonalData
    private String phone;
    private String comment;
    private String lang;
    private int adults;
    private int children;
    private BigDecimal amount;
    private PriceMap prices;
    private boolean paid;
    private Instant onlineWarrantyDeadlineDate;
    private boolean bookingGuaranteeAutoBookingCancel;
    private ExtraArray extraArray;

    @JsonIgnore
    public boolean isAutomaticallyCancelled() {
        return extraArray != null && extraArray.getCancelReasonClass() == 1;
    }

    @JsonPOJOBuilder(withPrefix = "")
    public static class BookingBuilder {
        @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
        private LocalDateTime arrival;
        @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
        private LocalDateTime departure;
        @JsonDeserialize(using = Serialization.StringToPriceMapDeserializer.class)
        private PriceMap prices;
        @JsonDeserialize(using = Serialization.IntegerToBooleanDeserializer.class)
        private boolean paid;
        @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ssX")
        private Instant onlineWarrantyDeadlineDate;
        @JsonDeserialize(using = Serialization.IntegerToBooleanDeserializer.class)
        private boolean bookingGuaranteeAutoBookingCancel;
    }

    public static class PriceMap extends HashMap<LocalDate, BigDecimal> implements Map<LocalDate, BigDecimal> {
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = ExtraArray.ExtraArrayBuilder.class)
    public static class ExtraArray {
        private int cancelReasonClass;

        @JsonPOJOBuilder(withPrefix = "")
        public static class ExtraArrayBuilder {
        }

    }
}
