package ru.yandex.travel.hotels.common.partners.bnovo.model;

import com.fasterxml.jackson.annotation.JsonCreator;

public enum BookingStatusId {
    CONFIRMED(1),
    CANCELLED(2);

    private int value;

    BookingStatusId(int value) {
        this.value = value;
    }

    @JsonCreator
    public static BookingStatusId fromInt(int value) {
        for (BookingStatusId candidate : BookingStatusId.values()) {
            if (candidate.value == value) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown BookingStatusId type %s", value)
        );
    }
}
