package ru.yandex.travel.hotels.common.partners.bnovo.model;

import com.fasterxml.jackson.annotation.JsonCreator;

public enum CancellationFineType {
    NO_PENALTY(0),
    PERCENTAGE(2),
    FIXED_AMOUNT(3),
    FIRST_NIGHT(4),
    FULL_AMOUNT(5);

    private int value;

    CancellationFineType(int value) {
        this.value = value;
    }

    @JsonCreator
    public static CancellationFineType fromInt(int value) {
        for (CancellationFineType candidate : CancellationFineType.values()) {
            if (candidate.value == value) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
            String.format("Unknown cancellation fine type %s", value)
        );
    }
}
