package ru.yandex.travel.hotels.common.partners.bnovo.model;

import java.util.Set;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = ConfirmationResponse.ConfirmationResponseBuilder.class)
public class ConfirmationResponse {
    @Singular
    private Set<String> confirmedBookings;
    @Singular
    private Set<String> alreadyCancelledBookings;

    @JsonPOJOBuilder(withPrefix = "")
    public static class ConfirmationResponseBuilder {
    }
}
