package ru.yandex.travel.hotels.common.partners.bnovo.model;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Map;
import java.util.TimeZone;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Hotel.HotelBuilder.class)
public class Hotel {
    private long id;
    private String name;
    private String phone;
    private String email;
    private String address;
    private boolean enabled;
    private String checkin;
    private String checkout;
    private GeoData geoData;
    private String country;
    private TimeZone timezone;
    private String uid;
    private Map<String, AgeGroup> childrenAges;

    public Instant getCheckinInstantForDate(LocalDate checkinDate) {
        return checkinDate.atTime(LocalTime.parse(checkin)).atZone(timezone.toZoneId()).toInstant();
    }

    @JsonPOJOBuilder(withPrefix = "")
    public static class HotelBuilder {
        @JsonDeserialize(using = Serialization.IntegerToBooleanDeserializer.class)
        private boolean enabled;
        @JsonDeserialize(using = Serialization.GeoDataDeserializer.class)
        private GeoData geoData;
        @JsonDeserialize(using = Serialization.MapFromListOrMapDeserializer.class)
        private Map<String, AgeGroup> childrenAges;
    }
}
