package ru.yandex.travel.hotels.common.partners.bnovo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

@RequiredArgsConstructor
public enum HotelConnectionStatus {
    CONNECTED("connected"),
    NOT_CONNECTED("not_connected");

    private final String code;

    @JsonCreator
    public static HotelConnectionStatus fromString(String value) {
        for (HotelConnectionStatus candidate : HotelConnectionStatus.values()) {
            if (candidate.code != null && candidate.code.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown connection status %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return code;
    }
}
