package ru.yandex.travel.hotels.common.partners.bnovo.model;

import java.time.LocalDateTime;
import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = HotelDetails.HotelDetailsBuilder.class)
public class HotelDetails {

    /**
     * According to bnovo internal terminology it is account id. We use it to communicate with bnovo via API.
     */
    private final String hotelCode;
    /**
     * the hotel id in the system that the user sees.
     */
    private final String bnovoId;

    private final Address address;

    private final List<HotelContactInfo> contactInfo;

    private final BankAccountDetails bankAccountDetails;

    private final HotelConnectionStatus connectionStatus;

    private final LocalDateTime connectionStatusUpdatedAt;

    @JsonPOJOBuilder(withPrefix = "")
    public static class HotelDetailsBuilder {
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = HotelContactInfo.HotelContactInfoBuilder.class)
    public static class HotelContactInfo {

        private final String name;

        private final String position;

        private final String phone;

        private final String email;

        private final ContactType contactType;

        @JsonPOJOBuilder(withPrefix = "")
        public static class HotelContactInfoBuilder {
        }
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = BankAccountDetails.BankAccountDetailsBuilder.class)
    public static class BankAccountDetails {

        private final String personLegalName;

        private final String branchName;

        private final String country;

        private final Address address;

        private final String phone;

        private final String inn;

        private final String kpp;

        private final String bankName;

        private final String bic;

        private final String correspondingAccount;

        private final String currentAccount;

        private final TaxType tax;

        @JsonPOJOBuilder(withPrefix = "")
        public static class BankAccountDetailsBuilder {
        }
    }

    @Value
    @Builder(toBuilder = true)
    @JsonDeserialize(builder = Address.AddressBuilder.class)
    public static class Address {

        private final String postalCode;

        private final String country;

        private final String region;

        private final String cityName;

        private final String addressLine;

        @JsonPOJOBuilder(withPrefix = "")
        public static class AddressBuilder {
        }
    }
}
