package ru.yandex.travel.hotels.common.partners.bnovo.model;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Offer.OfferBuilder.class)
public class Offer {
    private int adults;
    private int children;
    private long planId;
    private long roomtypeId;
    private BigDecimal price;
    @Singular
    private Map<LocalDate, BigDecimal> pricesByDates;

    @JsonPOJOBuilder(withPrefix = "")
    public static class OfferBuilder {
    }
}
