package ru.yandex.travel.hotels.common.partners.bnovo.model;

import java.time.LocalDate;
import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = PriceLosRequest.PriceRequestBuilder.class)
public class PriceLosRequest {
    @Singular
    private List<Long> accounts;

    private LocalDate checkinFrom;
    private LocalDate checkinTo;
    private int nights;
    private int adults;
    private int children;
    private String requestId;


    @JsonPOJOBuilder(withPrefix = "")
    public static class PriceRequestBuilder {
    }
}
