package ru.yandex.travel.hotels.common.partners.bnovo.model;

import java.math.BigDecimal;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.misc.lang.StringUtils;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = RatePlan.RatePlanBuilder.class)
public class RatePlan {
    private long id;
    private long accountId;
    private String name;
    private String nameRu;
    private String nameEn;
    private String description;
    private String descriptionRu;
    private String descriptionEn;
    private boolean isDefault;
    private boolean enabled;
    private boolean enabledOTA;
    private boolean enabledYandex;
    private boolean forPromoCode;
    private String cancellationRules;
    private Integer cancellationDeadline;
    private CancellationFineType cancellationFineType;
    private BigDecimal cancellationFineAmount;
    private Boolean[] nutrition;
    private boolean boardFromServices;
    private List<Long> additionalServicesIds;
    private WarrantyType warrantyType;


    @JsonIgnore
    public String getDefaultName() {
        if (StringUtils.isNotEmpty(nameRu)) {
            return nameRu;
        } else {
            return name;
        }
    }

    @JsonIgnore
    public String getDefaultDescription() {
        if (StringUtils.isNotEmpty(descriptionRu)) {
            return descriptionRu;
        } else {
            return description;
        }
    }

    @JsonPOJOBuilder(withPrefix = "")
    public static class RatePlanBuilder {
        @JsonDeserialize(using = Serialization.IntegerToBooleanDeserializer.class)
        @JsonProperty("default")
        private boolean isDefault;
        @JsonDeserialize(using = Serialization.IntegerToBooleanDeserializer.class)
        private boolean enabled;
        @JsonDeserialize(using = Serialization.IntegerToBooleanDeserializer.class)
        private boolean enabledOTA;
        @JsonDeserialize(using = Serialization.IntegerToBooleanDeserializer.class)
        private boolean enabledYandex;
        @JsonDeserialize(using = Serialization.IntegerToBooleanDeserializer.class)
        private boolean forPromoCode;
        @JsonDeserialize(using = Serialization.BitMaskDeserializer.class)
        private Boolean[] nutrition;
        @JsonDeserialize(using = Serialization.IntegerToBooleanDeserializer.class)
        private boolean boardFromServices;
        @JsonDeserialize(using = ru.yandex.travel.hotels.common.partners.expedia.model.common.Deserializers.ListFromListOrMapDeserializer.class)
        private List<Long> additionalServicesIds;
    }
}
