package ru.yandex.travel.hotels.common.partners.bnovo.model;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = RoomExtra.RoomExtraBuilder.class)
@JsonIgnoreProperties(ignoreUnknown = true)
public class RoomExtra {
    @JsonDeserialize(using = Serialization.MapFromListOrMapDeserializer.class)
    private Map<String, Integer> childrenAges;

    @JsonPOJOBuilder(withPrefix = "")
    public static class RoomExtraBuilder {
    }
}
