package ru.yandex.travel.hotels.common.partners.bnovo.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = RoomPhoto.RoomPhotoBuilder.class)
@JsonIgnoreProperties(ignoreUnknown = true)
public class RoomPhoto {
    private long id;
    private String url;
    private String thumb;

    @JsonPOJOBuilder(withPrefix = "")
    public static class RoomPhotoBuilder {
    }
}
