package ru.yandex.travel.hotels.common.partners.bnovo.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.misc.lang.StringUtils;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = RoomType.RoomTypeBuilder.class)
@JsonIgnoreProperties(ignoreUnknown = true)
public class RoomType {
    private long id;
    private long accountId;
    private long parentId;
    private String name;
    private String nameRu;
    private String nameEn;
    private String description;
    private String descriptionRu;
    private String descriptionEn;
    private int adults;
    private int children;
    private AccommodationType accommodationType;
    private List<RoomPhoto> photos;
    private RoomExtra extraArray;

    @JsonIgnore
    public String getDefaultName() {
        if (StringUtils.isNotEmpty(nameRu)) {
            return nameRu;
        } else {
            return name;
        }
    }

    @JsonIgnore
    public String getDefaultDescription() {
        if (StringUtils.isNotEmpty(descriptionRu)) {
            return descriptionRu;
        } else {
            return description;
        }
    }


    @JsonPOJOBuilder(withPrefix = "")
    public static class RoomTypeBuilder {
    }
}
