package ru.yandex.travel.hotels.common.partners.bnovo.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = RoomTypeList.RoomTypeListBuilder.class)
@JsonIgnoreProperties(ignoreUnknown = true)
public class RoomTypeList {
    @JsonProperty("rooms")
    private List<RoomType> rooms;

    @JsonPOJOBuilder(withPrefix = "")
    public static class RoomTypeListBuilder {
    }
}
