package ru.yandex.travel.hotels.common.partners.bnovo.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

import ru.yandex.misc.lang.StringUtils;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Service.ServiceBuilder.class)
public class Service {
    private long id;
    private long accountId;
    private String name;
    private String nameRu;
    private String nameEn;
    private String description;
    private String descriptionRu;
    private String descriptionEn;
    private int price;
    private ServiceType type;
    private ServiceBoardType boardType;
    private ServicePriceType priceType;
    private boolean enabled;
    private boolean oneTime;
    private boolean maxQuantityEnabled;
    private int maxQuantity;
    private Long imageId;
    private Integer order;
    private boolean isPackage;
    private List<Long> packageAdditionalServicesIds;


    @JsonIgnore
    public String getDefaultName() {
        if (StringUtils.isNotEmpty(nameRu)) {
            return nameRu;
        } else {
            return name;
        }
    }

    @JsonIgnore
    public String getDefaultDescription() {
        if (StringUtils.isNotEmpty(descriptionRu)) {
            return descriptionRu;
        } else {
            return description;
        }
    }

    @JsonPOJOBuilder(withPrefix = "")
    public static class ServiceBuilder {
        @JsonDeserialize(using = Serialization.IntegerToBooleanDeserializer.class)
        private boolean enabled;
        @JsonDeserialize(using = Serialization.IntegerToBooleanDeserializer.class)
        private boolean oneTime;
        @JsonDeserialize(using = Serialization.IntegerToBooleanDeserializer.class)
        private boolean maxQuantityEnabled;
        @JsonDeserialize(using = Serialization.IntegerToBooleanDeserializer.class)
        private boolean isPackage;
        @JsonDeserialize(using =
                ru.yandex.travel.hotels.common.partners.expedia.model.common.Deserializers.ListFromListOrMapDeserializer.class)
        private List<Long> packageAdditionalServicesIds;
    }
}
