package ru.yandex.travel.hotels.common.partners.bnovo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ServiceBoardType {
    BREAKFAST("breakfast"),
    LUNCH("lunch"),
    DINNER("dinner"),
    PACKAGE("package"),
    OTHER("other");
    private final String value;

    ServiceBoardType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static ServiceBoardType fromString(String value) {
        if ("".equals(value)) {
            return OTHER;
        }
        for (var candidate : ServiceBoardType.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown ServiceBoardType %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
