package ru.yandex.travel.hotels.common.partners.bnovo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ServicePriceType {
    PERSON("person"),
    SERVICE("service");
    private final String value;

    ServicePriceType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static ServicePriceType fromString(String value) {
        for (var candidate : ServicePriceType.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown ServicePriceType %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
