package ru.yandex.travel.hotels.common.partners.bnovo.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ServiceType {
    BOARD("board"),
    OTHER("other");
    private final String value;

    ServiceType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static ServiceType fromString(String value) {
        if ("".equals(value)) {
            return OTHER;
        }
        for (var candidate : ServiceType.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                String.format("Unknown ServiceType %s", value)
        );
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
