package ru.yandex.travel.hotels.common.partners.bnovo.model;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Singular;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Stay.StayBuilder.class)
public class Stay {
    private LocalDate checkin;
    private String currency;
    private int nights;
    @Singular
    private List<Offer> rates;
    private ZonedDateTime timestamp;

    @JsonPOJOBuilder(withPrefix = "")
    public static class StayBuilder {
    }
}
