package ru.yandex.travel.hotels.common.partners.bnovo.model;

import java.util.Arrays;

import com.fasterxml.jackson.annotation.JsonCreator;

public enum WarrantyType {
    NO_WARRANTY("no"),
    ONLINE_PAY("onlinepay"),
    CARD_WARRANTY("card_warranty"),
    OTHER("other");

    private final String value;

    WarrantyType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static WarrantyType fromValue(String value) {
        return Arrays.stream(WarrantyType.values())
                .filter(warrantyType -> warrantyType.value.equals(value))
                .findFirst()
                .orElse(OTHER);
    }
}
