package ru.yandex.travel.hotels.common.partners.bnovo.utils;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.validation.constraints.NotNull;

import com.google.common.base.Preconditions;

import ru.yandex.travel.hotels.common.pansions.PansionUnifier;
import ru.yandex.travel.hotels.common.partners.bnovo.model.RatePlan;
import ru.yandex.travel.hotels.common.partners.bnovo.model.Service;
import ru.yandex.travel.hotels.common.partners.bnovo.model.ServiceBoardType;
import ru.yandex.travel.hotels.common.partners.bnovo.model.ServiceType;
import ru.yandex.travel.hotels.proto.EPansionType;

public class BNovoPansionHelper {

    public static EPansionType getPansionType(@NotNull RatePlan plan, @NotNull Map<Long, Service> additionalServices) {
        if (plan.isBoardFromServices()) {
            Set<ServiceBoardType> allBoardTypes = new HashSet<>();
            if (plan.getAdditionalServicesIds() != null) {
                plan.getAdditionalServicesIds().stream()
                        .map(additionalServices::get)
                        .filter(s -> s != null && s.getType() == ServiceType.BOARD && s.getBoardType() != ServiceBoardType.PACKAGE)
                        .map(Service::getBoardType)
                        .forEach(allBoardTypes::add);
                plan.getAdditionalServicesIds().stream()
                        .map(additionalServices::get)
                        .filter(s -> s != null && s.getType() == ServiceType.BOARD && s.getBoardType() == ServiceBoardType.PACKAGE)
                        .flatMap(s -> s.getPackageAdditionalServicesIds().stream())
                        .map(additionalServices::get)
                        .filter(s -> s != null && s.getType() == ServiceType.BOARD && s.getBoardType() != ServiceBoardType.PACKAGE)
                        .map(Service::getBoardType)
                        .forEach(allBoardTypes::add);
            }
            return PansionUnifier.get(false, false, false,
                    allBoardTypes.contains(ServiceBoardType.BREAKFAST),
                    allBoardTypes.contains(ServiceBoardType.LUNCH),
                    allBoardTypes.contains(ServiceBoardType.DINNER));
        } else {
            return getPansionTypeFromFlags(plan.getNutrition());
        }
    }


    private static EPansionType getPansionTypeFromFlags(Boolean[] nutritionMask) {
        Preconditions.checkArgument(nutritionMask.length == 3,
                "Unexpected size of nutrition mask");
        // 111
        if (nutritionMask[0] && nutritionMask[1] && nutritionMask[2]) {
            return EPansionType.PT_FB;
        }
        //101
        if (nutritionMask[0] && !nutritionMask[1] && nutritionMask[2]) {
            return EPansionType.PT_HB;
        }
        // 001
        if (!nutritionMask[0] && !nutritionMask[1] && nutritionMask[2]) {
            return EPansionType.PT_BD;
        }
        // 100
        if (nutritionMask[0] && !nutritionMask[1] && !nutritionMask[2]) {
            return EPansionType.PT_BB;
        }
        // 000
        if (!nutritionMask[0] && !nutritionMask[1] && !nutritionMask[2]) {
            return EPansionType.PT_RO;
        }
        return EPansionType.PT_UNKNOWN;
    }
}
