package ru.yandex.travel.hotels.common.partners.booking;

import java.util.Set;
import java.util.concurrent.CompletableFuture;

import ru.yandex.travel.commons.proto.ECurrency;
import ru.yandex.travel.hotels.common.partners.booking.model.BlockAvailability;
import ru.yandex.travel.hotels.common.partners.booking.model.Hotels;
import ru.yandex.travel.hotels.common.partners.booking.model.Hotel;

import static ru.yandex.travel.hotels.common.partners.base.Helpers.sync;

public interface BookingClient {

    CompletableFuture<BlockAvailability> getBlockAvailability(String checkIn, String checkOut,
                                                              Set<String> hotelsIds, String occupancy,
                                                              ECurrency currency, String requestId,
                                                              BookingUserPlatform userPlatform);

    CompletableFuture<Hotels> getHotels(Set<String> hotelIds, String requestId);

    CompletableFuture<Hotel> getHotel(String hotelId, String requestId);

    default Hotel getHotelSync(String hotelId, String requestId) {
        return sync(getHotel(hotelId, requestId));
    }
}
