package ru.yandex.travel.hotels.common.partners.booking.model;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Block.BlockBuilder.class)
public class Block {

    private String blockId;

    private int maxOccupancy;

    private int maxChildrenFree;

    private int maxChildrenFreeAge;

    private List<IncrementalPrice> incrementalPrice;

    private MinPrice minPrice;

    private String name;

    private boolean fullBoard;

    private boolean halfBoard;

    private boolean breakfastIncluded;

    private boolean lunchIncluded;

    private boolean dinnerIncluded;

    private boolean allInclusive;

    private String roomId;

    private int numberOfRoomsLeft;

    private boolean freeWifi;

    private boolean refundable;

    private List<CancellationInfo> cancellationInfo;

    private DealTagging dealTagging;

    @JsonPOJOBuilder(withPrefix = "")
    public static class BlockBuilder {
    }
}
