package ru.yandex.travel.hotels.common.partners.booking.model;

import java.time.LocalDateTime;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = CancellationInfo.CancellationInfoBuilder.class)
public class CancellationInfo {

    private String guestCurrencyFeePretty;

    private double guestCurrencyFee;

    private String guestCurrency;

    private double fee;

    private String currency;

    private String timezone;

    private LocalDateTime from;

    private LocalDateTime until;

	@JsonPOJOBuilder(withPrefix = "")
    public static class CancellationInfoBuilder {
    }
}
