package ru.yandex.travel.hotels.common.partners.booking.model;

import java.time.LocalDate;
import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Builder;
import lombok.Value;

@Value
@Builder(toBuilder = true)
@JsonDeserialize(builder = Result.ResultBuilder.class)
public class Result {

    private String hotelId;

    private String hotelUrl;

    private List<Block> block;

    private LocalDate checkin;

    private LocalDate checkout;

    @JsonPOJOBuilder(withPrefix = "")
    public static class ResultBuilder {
    }
}
