package ru.yandex.travel.hotels.common.partners.bronevik;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import ru.yandex.travel.hotels.common.partners.base.CallContext;

import static ru.yandex.travel.hotels.common.partners.base.Helpers.sync;


public interface BronevikClient {

    CompletableFuture<PingResponse> ping();
    CompletableFuture<HotelsWithInfo> getHotelsInfo(List<Integer> hotelIds, String requestId);
    CompletableFuture<HotelWithInfo> getHotelInfo(Integer hotelId, String requestId);
    CompletableFuture<GetMealsResponse> getMeals(String requestId);
    CompletableFuture<SearchHotelOffersResponse> searchHotelOffers(int adults,
                                                                   List<Integer> children,
                                                                   List<Integer> hotelIds,
                                                                   String checkIn,
                                                                   String checkOut,
                                                                   String currency,
                                                                   String requestId);

    CompletableFuture<GetHotelOfferPricingResponse> getHotelOfferPricing(String offerCode, List<Guest> guests,
                                                                         List<Integer> meals, String currency,
                                                                         String requestId, List<Child> children);

    CompletableFuture<CreateOrderResponse> createOrder(String offerCode, List<Guest> guests,
                                                       List<Integer> meals, String currency,
                                                       String referenceId, String requestId, List<Child> children);

    CompletableFuture<GetOrderResponse> getOrder(Integer OrderId, String requestId);

    CompletableFuture<CancelOrderResponse> cancelOrder(Integer orderId, String requestId);

    CompletableFuture<SearchOrdersResponse> searchOrdersByReferenceId(String referenceId, String requestId);

    CompletableFuture<GetAmenitiesResponse> getAmenities(String requestId);

    default HotelWithInfo getHotelInfoSync(Integer hotelId, String requestId) {
        return sync(getHotelInfo(hotelId, requestId));
    }

    default GetHotelOfferPricingResponse getHotelOfferPricingSync(String offerCode, List<Guest> guests,
                                                                  List<Integer> meals, String currency,
                                                                  String requestId, List<Child> children) {
        return sync(getHotelOfferPricing(offerCode, guests, meals, currency, requestId, children));
    }

    default CreateOrderResponse createOrderSync(String offerCode, List<Guest> guests,
                                                List<Integer> meals, String currency,
                                                String referenceId, String requestId, List<Child> children) {
        return sync(createOrder(offerCode, guests,  meals, currency, referenceId, requestId, children));
    }

    default GetOrderResponse getOrderSync(Integer orderId, String requestId) {
        return sync(getOrder(orderId, requestId));
    }

    default CancelOrderResponse cancelOrderSync(Integer orderId, String requestId) {
        return sync(cancelOrder(orderId, requestId));
    }

    default SearchOrdersResponse searchOrdersByReferenceIdSync(String referenceId, String requestId) {
        return sync(searchOrdersByReferenceId(referenceId, requestId));
    }

    default GetAmenitiesResponse getAmenitiesSync(String requestId) {
        return sync(getAmenities(requestId));
    }

    default BronevikClient withCallContext(CallContext callContext) {
        return new TestContextBronevikClient(callContext, this);
    }
}
