package ru.yandex.travel.hotels.common.partners.bronevik;

import javax.validation.constraints.NotNull;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.validation.annotation.Validated;

import ru.yandex.travel.hotels.common.partners.base.BaseSOAPClientProperties;

@EqualsAndHashCode(callSuper = true)
@Validated
@Data
public class BronevikClientProperties extends BaseSOAPClientProperties {

    @NotNull
    public String clientKey;

    @NotNull
    public String login;

    @NotNull
    public String password;

    @NotNull
    public SOAPType soapType;

    private boolean enableRetries = false;

    public int numRetries = 10;

    public double retryRateLimiter = 0.5;
}
