package ru.yandex.travel.hotels.common.partners.bronevik;

import com.fasterxml.jackson.annotation.JsonValue;

public enum SOAPType {
    DEVELOPMENT("development"),
    PRODUCTION("production");
    private final String value;

    SOAPType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    public static SOAPType getSOAPType(String value) {
        for (var soapType: SOAPType.values()){
            if (soapType.value != null && soapType.value.equals(value)) {
                return soapType;
            }
        }
        return DEVELOPMENT;
    }
}
