package ru.yandex.travel.hotels.common.partners.bronevik.model;

public enum BedType {
    SINGLE("single"),
    DOUBLE("double"),
    SOFA("sofa"),
    BUNK_BED("bunk-bed"),
    UNKNOWN(null);

    private String value;

    BedType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static BedType fromValue(String value) {
        for (var bedType: BedType.values()) {
            if (bedType.value != null && bedType.value.equals(value)) {
                return bedType;
            }
        }

        return UNKNOWN;
    }
}
