package ru.yandex.travel.hotels.common.partners.bronevik.model;

import ru.yandex.travel.commons.enums.ValueBasedEnum;

public enum FaultCode implements ValueBasedEnum<Integer> {
    INTERNAL_ERROR(1001),
    INVALID_OFFER_CODE(5000),
    SOLD_OUT(5001),
    UNKNOWN(null);


    private Integer value;

    FaultCode(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

    public static FaultCode fromValue(Integer value) {
        for (var faultCode : FaultCode.values()) {
            if (faultCode.value != null && faultCode.value.equals(value)) {
                return faultCode;
            }
        }

        return UNKNOWN;
    }
}
